#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("ConsensusClusterPlus")


library(ConsensusClusterPlus)       #library package
expFile="metabolismGeneExp.txt"            #expression data file
workDir="D:\\metabolism\\LGG\\3.Subtype"    
setwd(workDir)      

#read input file
data=read.table(expFile, header=T, sep="\t", check.names=F, row.names=1)
data=as.matrix(data)

#Cluster the samples
maxK=9
results=ConsensusClusterPlus(data,
              maxK=maxK,
              reps=50,
              pItem=0.8,
              pFeature=1,
              title=workDir,
              clusterAlg="km",
              distance="euclidean",
              seed=12345,
              plot="png")


#output typing result
clusterNum=4        #into several subtypes
cluster=results[[clusterNum]][["consensusClass"]]
cluster=as.data.frame(cluster)
colnames(cluster)=c("metabolismcluster")
letter=c("A","B","C","D","E","F","G")
uniqClu=levels(factor(cluster$metabolismcluster))
cluster$metabolismcluster=letter[match(cluster$metabolismcluster, uniqClu)]
clusterOut=rbind(ID=colnames(cluster), cluster)
write.table(clusterOut, file="metabolismcluster.txt", sep="\t", quote=F, col.names=F)


